<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-6">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> Poin Belanja</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover sett">
                            <tbody>
                                <tr>
                                    <td width="30%">Minimal Belanja</td>
                                    <td>
                                        <span class='edit'>
                                            {{ number_format(modull('POIN')->judul, 0, ',', '.') }}
                                        </span>
                                        <input type="text" name="" id="" class="txtedit form-control"
                                            value='{{ modull('POIN')->judul }}' data-id='{{ modull('POIN')->id }}'
                                            field="judul" placeholder="Rp.0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Bonus Poin</td>
                                    <td>
                                        <span class='edit'>
                                            {{ number_format(modull('POIN')->isi, 0, ',', '.') }}
                                        </span>
                                        <input type="text" name="" id="" class="txtedit form-control"
                                            value="{{ modull('POIN')->isi }}" data-id="{{ modull('POIN')->id }}"
                                            field="isi" placeholder="0">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="col-lg-6">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">

                        <h3 class="card-title"><i class="fa fa-print text-primary"></i> Status Print Struk</h3>
                    </div>
                    <div class="card-body">

                        <table class="table table-bordered table-hover sett">
                            <tbody>
                                <tr>
                                    <td width="30%">Print Otomatis</td>
                                    <td width="5%">
                                        <div class="custom-control custom-radio">
                                            <input class="custom-control-input" type="radio" id="otomatis"
                                                {{ modull('PRINT')->status == 'Y' ? 'checked' : '' }} value="Y"
                                                name="print" field="status" data-id="{{ modull('PRINT')->id }}">
                                            <label for="otomatis" class="custom-control-label ">
                                            </label>
                                        </div>
                                    </td>
                                    <td>
                                        <span class='edit'>
                                            Kode Printer : {{ modull('PRINT')->isi }}
                                        </span>
                                        <input type="text" name="" id="" class="txtedit form-control"
                                            value="{{ modull('PRINT')->isi }}" data-id="{{ modull('PRINT')->id }}"
                                            field="isi" placeholder="0">

                                    </td>
                                    <td width="20%" class="text-center">
                                        <a class=" btn btn-info btn-sm" href="/coba-print"><i class="fa fa-print"></i>
                                            Tes
                                            Printer</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="30%">Print Manual</td>
                                    <td>
                                        <div class="custom-control custom-radio">
                                            <input class="custom-control-input" type="radio" id="manual"
                                                {{ modull('PRINT')->status == 'N' ? 'checked' : '' }} value="N"
                                                name="print" field="status" data-id="{{ modull('PRINT')->id }}">
                                            <label for="manual" class="custom-control-label ">
                                            </label>
                                        </div>
                                    </td>
                                    <td colspan="2">
                                        Print Manual
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="col-lg-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">

                        <h3 class="card-title"><i class="fa fa-print text-primary"></i> Teks Print Struk</h3>
                    </div>
                    <div class="card-body">

                        <table class="table table-bordered table-hover sett">
                            <tbody>
                                <tr>
                                    <td width="20%">Nama Toko</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PNT')->judul }}
                                        </span>
                                        <input type="text" name="" id="" class="txtedit form-control"
                                            value="{{ modull('PNT')->judul }}" data-id="{{ modull('PNT')->id }}"
                                            field="judul" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Telp-</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PNT')->link }}
                                        </span>
                                        <input type="text" name="" id="" class="txtedit form-control"
                                            value="{{ modull('PNT')->link }}" data-id="{{ modull('PNT')->id }}"
                                            field="link" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PNT')->gambar }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PNT')->gambar }}"
                                            data-id="{{ modull('PNT')->id }}" field="gambar" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Kota Kabupaten</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PTX')->gambar }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PTX')->gambar }}"
                                            data-id="{{ modull('PTX')->id }}" field="gambar" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Alamat</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PNT')->isi }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PNT')->isi }}"
                                            data-id="{{ modull('PNT')->id }}" field="isi" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Text struk 1</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PTX')->judul }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PTX')->judul }}"
                                            data-id="{{ modull('PTX')->id }}" field="judul" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Text struk 2</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PTX')->isi }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PTX')->isi }}"
                                            data-id="{{ modull('PTX')->id }}" field="isi" placeholder="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Text struk 3</td>
                                    <td>
                                        <span class='edit'>
                                            {{ modull('PTX')->link }}
                                        </span>
                                        <input type="text" name="" id=""
                                            class="txtedit form-control" value="{{ modull('PTX')->link }}"
                                            data-id="{{ modull('PTX')->id }}" field="link" placeholder="0">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>


    <x-slot:foot>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script>
            $(document).ready(function() {
                var token = $("meta[name='csrf-token']").attr("content");
                $('#otomatis').click(function() {
                    var id = $(this).attr('data-id');
                    var value = $(this).val();
                    var field = $(this).attr('field');
                    $.ajax({
                        type: "POST",
                        url: "edit-modul",
                        data: {
                            id: id,
                            value: value,
                            field: field,
                            _token: token,
                        },
                        success: function(data) {
                            toastr.success("Data berhasil dirubah.");
                            document.location.href = "";
                        },
                    });
                })

                $('#manual').click(function() {
                    var id = $(this).attr('data-id');
                    var value = $(this).val();
                    var field = $(this).attr('field');
                    $.ajax({
                        type: "POST",
                        url: "edit-modul",
                        data: {
                            id: id,
                            value: value,
                            field: field,
                            _token: token,
                        },
                        success: function(data) {
                            toastr.success("Data berhasil dirubah.");
                            document.location.href = "";
                        },
                    });
                })

                $(".txtedit").hide();

                $(".edit").click(function() {
                    $(".txtedit").hide();
                    $(this).next(".txtedit").show().focus();
                    $(this).hide();
                });
                $(".txtedit").focusout(function() {
                    var id = $(this).attr('data-id');
                    var value = $(this).val();
                    var field = $(this).attr('field');

                    $(this).hide();
                    $(this).prev(".edit").show();
                    $(this).prev(".edit").text(value);

                    $.ajax({
                        type: "POST",
                        url: "edit-modul",
                        data: {
                            id: id,
                            value: value,
                            field: field,
                            _token: token,
                        },
                        success: function(data) {
                            toastr.success("Data berhasil dirubah.");
                            document.location.href = "";
                        },
                    });
                });
            });
        </script>
    </x-slot:foot>
</x-admin.contents>
